
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Years for the x-axis
year = [2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035]

# Renewable energy generation data (in billions of kWh)
renewable_energy = {
    "Solar": [2, 10, 25, 60, 130, 230, 380, 600],
    "Wind": [15, 30, 55, 100, 170, 260, 370, 500],
    "Hydro": [250, 260, 270, 280, 290, 300, 310, 320],
    "Geothermal": [10, 15, 20, 25, 30, 35, 40, 45],
    "Biomass": [20, 25, 30, 35, 40, 45, 50, 55]
}

# Extracted variables
legend_labels = list(renewable_energy.keys())
xlabel_value = "Year"
ylabel_value = "Energy Generation (Billions of kWh)"
title_value = "Growth of Renewable Energy Generation Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (2000, 2035)
ylim_values = (0, 1500)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = False
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FF66B2"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    renewable_energy.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)
ax.grid(True, linestyle='--', alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_72.pdf", bbox_inches="tight")
