

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for 12 months
time_step = np.linspace(1, 12, 12)
consumer_confidence = 100 + 10 * np.sin(np.pi * time_step / 6) + np.random.normal(0, 5, 12)
inflation_rate = 1.5 + 0.3 * time_step + np.random.normal(0, 0.2, 12)

# Extracted variables for labels and settings
consumer_confidence_label = "Consumer Confidence Index"
inflation_rate_label = "Inflation Rate (%)"
consumer_confidence_ylabel = "Consumer Confidence Index"
inflation_rate_xlabel = "Months"
inflation_rate_ylabel = "Inflation Rate (%)"
chart_title = "Economic Indicators Over 12 Months"
legend_labels = ["Consumer Confidence", "Inflation Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
consumer_confidence_ylim = [80, 130]
consumer_confidence_xlim = [1, 12]
inflation_rate_ylim = [1, 5]
inflation_rate_xlim = [1, 12]
consumer_confidence_yticks = np.arange(80, 135, 10)
consumer_confidence_xticks = np.arange(1, 13, 1)
inflation_rate_yticks = np.arange(1, 6, 1)
inflation_rate_xticks = np.arange(1, 13, 1)

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Plot Consumer Confidence Index
ax1.plot(time_step, consumer_confidence, "o-", color="#1f77b4", label=consumer_confidence_label)
ax1.fill_between(time_step, consumer_confidence, color="#aec7e8", alpha=0.3)
ax1.set_ylim(consumer_confidence_ylim)
ax1.set_xlim(consumer_confidence_xlim)
ax1.set_yticks(consumer_confidence_yticks)
ax1.set_xticks(consumer_confidence_xticks)
ax1.set_ylabel(consumer_confidence_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Inflation Rate
ax2.plot(time_step, inflation_rate, "s--", color="#ff7f0e", label=inflation_rate_label)
ax2.fill_between(time_step, inflation_rate, color="#ffbb78", alpha=0.3)
ax2.set_ylim(inflation_rate_ylim)
ax2.set_xlim(inflation_rate_xlim)
ax2.set_yticks(inflation_rate_yticks)
ax2.set_xticks(inflation_rate_xticks)
ax2.set_xlabel(inflation_rate_xlabel)
ax2.set_ylabel(inflation_rate_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="o", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="s", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[blue_line, orange_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=2,
    frameon=False,
)

# Add title to the plot
plt.suptitle(chart_title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("area_78.pdf", bbox_inches="tight")

