

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
time_step = np.linspace(0, 24, 48)
viewership = 70 + (np.arange(48) * 0.5 + np.random.normal(0, 3, 48))
engagement = 10 + 30 * np.abs(np.sin(np.pi * time_step / 8)) + np.random.normal(0, 5, 48)

# Extracted variables for labels and settings
viewership_label = "Viewership (%)"
engagement_label = "User Engagement (%)"
viewership_ylabel = "Viewership (%)"
engagement_xlabel = "Time (hours)"
engagement_ylabel = "User Engagement (%)"
legend_labels = ["Viewership", "User Engagement"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
engagement_ylim = [0, 50]
engagement_xlim = [0, 24]
viewership_ylim = [50, 100]
viewership_xlim = [0, 24]
viewership_yticks = np.arange(50, 101, 10)
viewership_xticks = np.arange(0, 25, 4)
engagement_yticks = np.arange(0, 51, 10)
engagement_xticks = np.arange(0, 25, 4)

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Plot Viewership
ax1.plot(time_step, viewership, "d-", color="#1f77b4", label=viewership_label)
ax1.fill_between(time_step, viewership, color="#aec7e8", alpha=0.3)
ax1.set_ylim(viewership_ylim)
ax1.set_xlim(viewership_xlim)
ax1.set_yticks(viewership_yticks)
ax1.set_xticks(viewership_xticks)
ax1.set_ylabel(viewership_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True, linestyle='--', alpha=0.7)

# Plot User Engagement
ax2.plot(time_step, engagement, "p--", color="#ff7f0e", label=engagement_label)
ax2.fill_between(time_step, engagement, color="#ffbb78", alpha=0.3)
ax2.set_ylim(engagement_ylim)
ax2.set_xlim(engagement_xlim)
ax2.set_yticks(engagement_yticks)
ax2.set_xticks(engagement_xticks)
ax2.set_xlabel(engagement_xlabel)
ax2.set_ylabel(engagement_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True, linestyle='--', alpha=0.7)

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="d", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="p", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[blue_line, orange_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=2,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_79.pdf", bbox_inches="tight")

