
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np 

# Data for the bar chart
companies = range(1, 11)
revenues = [108.5, 84.7, 78.2, 63.4, 59.9, 52.3, 45.7, 40.9, 38.1, 35.4]  # in billions of dollars
xlabel = "Top-10 Tech Companies in 2023"
ylabel = "Annual Revenue (in billion $)"
title = "Annual Revenue of Top-10 Tech Companies (2023)"
legend_label = "Average Revenue"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0.0, 120.0)
yticks = [0, 20, 40, 60, 80, 100, 120]

# Create the bar chart
plt.figure(figsize=(12, 7))  # Adjusting figure size for better readability
plt.bar(companies, revenues, color="#c96e6e")  # Using a warm color

# Add a horizontal line for the average revenue
average_revenue = np.mean(revenues)
plt.axhline(y=average_revenue, color="green", linestyle="--", linewidth=2, label=legend_label)

# Add labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Set y-axis limits
plt.ylim(ylim)

# Set x-axis, y-axis ticks
plt.xticks(companies, labels=["Apple", "Microsoft", "Amazon", "Google", "Facebook", "Alibaba", "Tencent", "IBM", "Intel", "Samsung"], rotation=45)
plt.yticks(yticks)

# Add a legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_102.pdf", bbox_inches="tight")
