

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Region A
region_a_metrics = ["Stress Levels", "Anxiety Levels", "Depression Rates", "Self-Esteem", "Mental Health Score"]
region_a_2020 = [70, 60, 50, 40, 80]
region_a_2021 = [68, 62, 48, 42, 82]
region_a_2022 = [65, 65, 45, 45, 85]
region_a_2023 = [60, 70, 40, 50, 90]

# Data for Region B
region_b_metrics = ["Stress Levels", "Anxiety Levels", "Depression Rates", "Self-Esteem", "Mental Health Score"]
region_b_2020 = [75, 65, 55, 35, 75]
region_b_2021 = [72, 67, 52, 38, 78]
region_b_2022 = [68, 70, 50, 40, 80]
region_b_2023 = [65, 75, 45, 45, 85]

xlabel = "Psychological Metrics"
ylabel = "Percentage (%)"
title = "Psychological Data Over Years"
title_region_a = "Region A - Psychological Data"
title_region_b = "Region B - Psychological Data"
labels = ["2020", "2021", "2022", "2023"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 150]
yticks = np.arange(0, 151, 30)

# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 8))  # Width, Height in inches

# Plot for Region A
x = np.arange(len(region_a_metrics))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

custom_colors = ["#5386E4", "#E4A953", "#53E45E", "#E45353"]

axs[0].bar(x - spacing * 1.5, region_a_2020, width, label=labels[0], color=custom_colors[0])
axs[0].bar(x - spacing / 2, region_a_2021, width, label=labels[1], color=custom_colors[1])
axs[0].bar(x + spacing / 2, region_a_2022, width, label=labels[2], color=custom_colors[2])
axs[0].bar(x + spacing * 1.5, region_a_2023, width, label=labels[3], color=custom_colors[3])
axs[0].set_title(title_region_a)
axs[0].set_xticks(x)
axs[0].set_xticklabels(region_a_metrics)
axs[0].set_ylim(ylim)
axs[0].set_yticks(yticks)
axs[0].legend(loc="upper left")

# Plot for Region B
x = np.arange(len(region_b_metrics))
axs[1].bar(x - spacing * 1.5, region_b_2020, width, color=custom_colors[0])
axs[1].bar(x - spacing / 2, region_b_2021, width, color=custom_colors[1])
axs[1].bar(x + spacing / 2, region_b_2022, width, color=custom_colors[2])
axs[1].bar(x + spacing * 1.5, region_b_2023, width, color=custom_colors[3])
axs[1].set_title(title_region_b)
axs[1].set_xticks(x)
axs[1].set_xticklabels(region_b_metrics)
axs[1].set_ylim(ylim)
axs[1].set_yticks(yticks)

# Add common labels
fig.text(0.5, -0.01, xlabel, ha='center', fontsize=12)
fig.text(-0.01, 0.5, ylabel, va='center', rotation='vertical', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_105.pdf", bbox_inches="tight")
