
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for USA
usa_genres = ["Action", "Comedy", "Drama", "Horror", "Romance"]
usa_imdb_ratings = [7.8, 6.5, 8.0, 5.6, 7.2]
usa_rotten_tomatoes = [75, 65, 80, 50, 70]
usa_metacritic = [70, 60, 75, 55, 68]
usa_audience_score = [80, 70, 85, 60, 75]

# Data for Canada
canada_genres = ["Action", "Comedy", "Drama", "Horror", "Romance"]
canada_imdb_ratings = [7.5, 6.8, 7.9, 5.8, 7.0]
canada_rotten_tomatoes = [72, 68, 78, 52, 68]
canada_metacritic = [68, 62, 74, 56, 66]
canada_audience_score = [78, 72, 83, 62, 73]

labels = ["IMDB Ratings", "Rotten Tomatoes", "Metacritic", "Audience Score"]
title = "Movie Ratings (%) for Different Geographic Regions"
title1 = "USA"
title2 = "Canada"

# Axis and Legend Labels
xlabel = "Movie Genres"
ylabel = "Ratings (%)"
legend_location = "upper left"

ylim1 = [0, 100]
yticks1 = np.arange(0, 101, 10)
ylim2 = [0, 100]
yticks2 = np.arange(0, 101, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 8))  # Width, Height in inches

# Colors
colors = ["#49759c", "#7da6a6", "#dea06e", "#948b57"]
x = np.arange(len(usa_genres))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

# Plot for USA
axs[0].bar(
    x - spacing * 1.5,
    usa_imdb_ratings,
    width,
    label=labels[0],
    color=colors[0],
)
axs[0].bar(x - spacing / 2, usa_rotten_tomatoes, width, label=labels[1], color=colors[1])
axs[0].bar(
    x + spacing / 2,
    usa_metacritic,
    width,
    label=labels[2],
    color=colors[2],
)
axs[0].bar(x + spacing * 1.5, usa_audience_score, width, label=labels[3], color=colors[3])
axs[0].set_title(title1, fontsize=14)
axs[0].set_xticks(x)
axs[0].set_xticklabels(usa_genres, fontsize=12)
axs[0].set_ylim(ylim1)
axs[0].set_yticks(yticks1)
axs[0].legend(loc=legend_location, ncol=2, fontsize=10)

# Plot for Canada
x = np.arange(len(canada_genres))
axs[1].bar(x - spacing * 1.5, canada_imdb_ratings, width, color=colors[0])
axs[1].bar(x - spacing / 2, canada_rotten_tomatoes, width, color=colors[1])
axs[1].bar(x + spacing / 2, canada_metacritic, width, color=colors[2])
axs[1].bar(x + spacing * 1.5, canada_audience_score, width, color=colors[3])
axs[1].set_title(title2, fontsize=14)
axs[1].set_xticks(x)
axs[1].set_xticklabels(canada_genres, fontsize=12)
axs[1].set_ylim(ylim2)
axs[1].set_yticks(yticks2)

# Add a common y-axis label and a super title
fig.text(
    0.0001,
    0.5,
    ylabel,
    va="center",
    rotation="vertical",
    fontsize=12,
)
fig.suptitle(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_106.pdf", bbox_inches="tight")
