
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
energy_sources = ["Solar", "Wind", "Hydro", "Bioenergy", "Geothermal"]
daily_generation = [50, 70, 90, 30, 20]
peak_generation = [100, 150, 110, 60, 50]
minimum_generation = [10, 20, 30, 10, 5]

title1 = "Daily Energy Generation"
axvline1 = 0
title2 = "Peak Energy Generation"
axvline2 = 0
title3 = "Minimum Energy Generation"
axvline3 = 0

xlabel = "Energy Generation (MWh)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks1 = [0, 20, 40, 60, 80, 100]
xticks2 = [0, 50, 100, 150]
xticks3 = [0, 10, 20, 30]

# Labels for annotations
annotation_color_positive = "#000000"
annotation_color_negative = "#FF0000"

# Set the figure size to match the original image's dimensions
fig, axes = plt.subplots(1, 3, figsize=(15, 6))

# Define colors for the bars
bar_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Plot for Daily Energy Generation
axes[0].barh(energy_sources, daily_generation, color=bar_colors, edgecolor="black")
axes[0].set_title(title1)
for i, v in enumerate(daily_generation):
    axes[0].text(
        v + 2,
        i,
        f"{v} MWh",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[0].axvline(axvline1, color="black")
axes[0].set_xticks(xticks1)

# Plot for Peak Energy Generation
axes[1].barh(energy_sources, peak_generation, color=bar_colors, edgecolor="black")
axes[1].set_title(title2)
for i, v in enumerate(peak_generation):
    axes[1].text(
        v + 2,
        i,
        f"{v} MWh",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[1].axvline(axvline2, color="black")
axes[1].set_xticks(xticks2)

# Plot for Minimum Energy Generation
axes[2].barh(energy_sources, minimum_generation, color=bar_colors, edgecolor="black")
axes[2].set_title(title3)
for i, v in enumerate(minimum_generation):
    axes[2].text(
        v + 2,
        i,
        f"{v} MWh",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[2].axvline(axvline3, color="black")
axes[2].set_xticks(xticks3)

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_114.pdf", bbox_inches="tight")
