
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
platforms = ["Netflix", "Amazon Prime", "Hulu", "Disney+", "HBO Max"]
viewership_2019 = [120.5, 60.3, 45.2, 50.7, 30.8]
viewership_2020 = [130.4, 75.6, 55.1, 65.2, 45.3]
viewership_2021 = [145.2, 80.7, 60.8, 70.3, 50.1]

title1 = "2019 Average Monthly Viewership"
axvline1 = 0
title2 = "2020 Average Monthly Viewership"
axvline2 = 0
title3 = "2021 Average Monthly Viewership"
axvline3 = 0

xlabel = "Viewership (in millions)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks1 = [0, 50, 100, 150, 200]
xticks2 = [0, 50, 100, 150, 200]
xticks3 = [0, 50, 100, 150, 200]

# Set the figure size to match the original image's dimensions
fig, axes = plt.subplots(1, 3, figsize=(12, 5))

# Color configurations
wheat_color = "#7FBF7F"  # Light Green
corn_color = "#FFD700"   # Yellow
soybean_color = "#8B4513" # Brown

# Plot for 2019 Average Monthly Viewership
axes[0].barh(platforms, viewership_2019, color=wheat_color, edgecolor="black")
axes[0].set_title(title1)
for i, v in enumerate(viewership_2019):
    axes[0].text(
        v + 0.5,
        i,
        f"{v}M",
        color="black",
        va="center",
        ha="left",
    )
axes[0].axvline(axvline1, color="black")
axes[0].set_xticks(xticks1)

# Plot for 2020 Average Monthly Viewership
axes[1].barh(platforms, viewership_2020, color=corn_color, edgecolor="black")
axes[1].set_title(title2)
for i, v in enumerate(viewership_2020):
    axes[1].text(
        v + 0.5,
        i,
        f"{v}M",
        color="black",
        va="center",
        ha="left",
    )
axes[1].axvline(axvline2, color="black")
axes[1].set_xticks(xticks2)

# Plot for 2021 Average Monthly Viewership
axes[2].barh(platforms, viewership_2021, color=soybean_color, edgecolor="black")
axes[2].set_title(title3)
for i, v in enumerate(viewership_2021):
    axes[2].text(
        v + 0.5,
        i,
        f"{v}M",
        color="black",
        va="center",
        ha="left",
    )
axes[2].axvline(axvline3, color="black")
axes[2].set_xticks(xticks3)

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_115.pdf", bbox_inches="tight")
