

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
models = ["Car", "Bus", "Bicycle", "Train"]
themes = ["Efficiency", "Cost", "Safety", "Comfort", "Speed"]
improvements = {
    "Efficiency": [3.2, 4.1, 2.8, 3.5],
    "Cost": [2.5, 3.8, 1.7, 4.2],
    "Safety": [4.0, 2.6, 3.1, 3.9],
    "Comfort": [3.7, 2.3, 4.0, 4.5],
    "Speed": [4.5, 3.0, 2.2, 4.8],
}

xlabel = "Mode of Transportation"
ylabel = "Index Score"
legendtitle = "Evaluation Criteria"
title = "Evaluation of Transportation Modes Across Different Criteria"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each theme
colors = ["#8e6c8a", "#6ca58c", "#d4a6a6", "#c19a6b", "#9c9a6b"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.15

# Positions of the bars on the x-axis
r = np.arange(len(models))

for i, theme in enumerate(themes):
    # Plot bars
    bars = plt.bar(
        r,
        improvements[theme],
        color=colors[i],
        hatch="//",
        width=bar_width,
        edgecolor="white",
        label=theme,
    )
    # Add text labels
    for bar, val in zip(bars, improvements[theme]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + (0.1 if val > 0 else -0.4),
            str(val),
            ha="center",
        )

    # Move the position for the next set of bars
    r = [x + bar_width for x in r]
# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks([r + bar_width * 2 for r in range(len(models))], models)

# Add ylabel
plt.ylabel(ylabel)

plt.gca().grid(color="gray", linewidth=0.5, linestyle='--')
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, bbox_to_anchor=(0.5, 1), loc="upper center", ncol=3)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_117.pdf", bbox_inches="tight")

