
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
strategies = ["Aggressive", "Balanced", "Conservative", "Growth"]
measures = ["Investment Return", "Risk", "Growth Rate", "Volatility", "Liquidity"]
performance = {
    "Investment Return": [12.5, 7.8, 5.3, 10.2],
    "Risk": [15.2, 10.4, 8.1, 12.7],
    "Growth Rate": [9.8, 6.5, 4.2, 8.5],
    "Volatility": [14.4, 9.9, 7.5, 11.3],
    "Liquidity": [11.1, 8.2, 6.0, 9.7],
}

xlabel = "Investment Strategy"
ylabel = "Performance Measure (%)"
legendtitle = "Financial Measure"
title = "Performance of Different Investment Strategies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each measure
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.15

# Positions of the bars on the x-axis
r = np.arange(len(strategies))

for i, measure in enumerate(measures):
    # Plot bars
    bars = plt.bar(
        r,
        performance[measure],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=measure,
    )
    # Add text labels
    for bar, val in zip(bars, performance[measure]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + (0.1 if val > 0 else -0.4),
            str(val),
            ha="center",
            fontsize=10,
        )

    # Move the position for the next set of bars
    r = [x + bar_width for x in r]
# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks([r + bar_width * 2 for r in range(len(strategies))], strategies)

# Add ylabel
plt.ylabel(ylabel, fontsize=12)

plt.gca().grid(color="gray", linewidth=0.5, linestyle='--')
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, bbox_to_anchor=(0.5, 1), loc="upper center", ncol=3)
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_119.pdf", bbox_inches="tight")
