
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
labels = ["Brazil", "India", "China", "Australia", "Russia", "USA"]
urban = [300, 280, 320, 260, 210, 290]
rural = [310, 290, 330, 270, 220, 300]
suburban = [305, 285, 325, 265, 215, 295]

x = np.arange(len(labels))  # the label locations
width = 0.25  # the width of the bars

# Variables for plot configuration
ylabel = "Average Monthly Rainfall (mm)"
xlabel_survey1 = "Survey Period 1"
xlabel_survey2 = "Survey Period 2"

legend_label_urban = "Urban"
legend_label_rural = "Rural"
legend_label_suburban = "Suburban"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = x
xticklabels = labels
ylim_ax1 = (200, 350)
ylim_ax2 = (210, 340)
yticks_ax1 = [200, 225, 250, 275, 300, 325, 350]
yticks_ax2 = [210, 230, 250, 270, 290, 310, 330, 340]

# Setting up the figure and axes for a 2 x 1 layout
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(8, 6), gridspec_kw={"height_ratios": [1, 1], "hspace": 0.3}
)

# Upper plot
rects1 = ax1.bar(
    x - width - 0.04,
    urban,
    width,
    label=legend_label_urban,
    color="#4c72b0",
    edgecolor="black",
)
rects2 = ax1.bar(
    x, rural, width, label=legend_label_rural, color="#55a868", edgecolor="black"
)
rects3 = ax1.bar(
    x + width + 0.04,
    suburban,
    width,
    label=legend_label_suburban,
    color="#c44e52",
    edgecolor="black"
)
# Lower plot
rects4 = ax2.bar(
    x - width - 0.04, urban, width, color="#4c72b0", edgecolor="black"
)
rects5 = ax2.bar(x, rural, width, color="#55a868", edgecolor="black")
rects6 = ax2.bar(
    x + width + 0.04, suburban, width, color="#c44e52", edgecolor="black"
)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel)
ax1.set_xlabel(xlabel_survey1)
ax2.set_xlabel(xlabel_survey2)
ax1.set_xticks(xticks)
ax1.set_xticklabels(xticklabels)
ax2.set_xticks(xticks)
ax2.set_xticklabels(xticklabels)
ax1.legend(loc="upper center", bbox_to_anchor=(0.5, 1.25), ncol=3, frameon=False)

# Set y-axis limit to match the reference picture
ax1.set_ylim(ylim_ax1)
ax2.set_ylim(ylim_ax2)
ax1.tick_params(axis="x", which="both", length=0)
ax2.tick_params(axis="x", which="both", length=0)
ax1.set_yticks(yticks_ax1)
ax2.set_yticks(yticks_ax2)

# Set grid color and style
ax1.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax2.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax1.tick_params(axis="y", which="major", color="gray")
ax2.tick_params(axis="y", which="major", color="gray")
ax1.set_axisbelow(True)
ax2.set_axisbelow(True)

# Remove top and right borders
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.spines["bottom"].set_visible(False)
ax1.spines["left"].set_color("gray")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.spines["bottom"].set_visible(False)
ax2.spines["left"].set_color("gray")

# Set supertitle
fig.suptitle('Average Monthly Rainfall by Demographic Groups')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_122.pdf", bbox_inches="tight")
