
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plots
energy_sources = ["Solar", "Wind", "Hydro"]
production_summer = np.array([[400, 500, 300], [350, 450, 400], [450, 250, 500]])
production_winter = np.array([[300, 400, 500], [450, 350, 400], [450, 450, 300]])

# Variables for plot configuration
xlabel_value = "Energy Production (MWh)"
ylabel_value = "Energy Source"
title_summer = "Summer Energy Production"
title_winter = "Winter Energy Production"
legend_labels = ["Region A", "Region B", "Region C"]
fig_title = "Energy Production Comparison by Season"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the bars
colors = ["#8ca252", "#d8b365", "#e5e5e5"]
width = 0.3
xlim_value = (0, 1200)
xticks_value = [0, 200, 400, 600, 800, 1000, 1200]
yticks_value = energy_sources
fontsize_title = 16

# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, roles, colors):
    bottom = np.zeros(len(roles))
    for i in range(counts.shape[1]):
        ax.barh(
            roles, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for Summer Energy Production
plot_stacked_bars(ax1, production_summer, energy_sources, colors)
ax1.set_title(title_summer)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7, linestyle='--', linewidth=0.7)  # Add grid lines
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for Winter Energy Production
plot_stacked_bars(ax2, production_winter, energy_sources, colors)
ax2.set_title(title_winter)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7, linestyle='--', linewidth=0.7)  # Add grid lines
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_126.pdf", bbox_inches="tight")

