

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plots
schools = ["Rationalism", "Empiricism", "Existentialism"]
counts_publications_2021 = np.array([[100, 75, 150], [120, 90, 140], [110, 95, 130]])
counts_publications_2022 = np.array([[130, 85, 160], [140, 110, 145], [115, 120, 135]])

# Variables for plot configuration
xlabel_value = "Number of Publications"
ylabel_value = "Philosophical Schools"
title_publications_2021 = "Publications in 2021"
title_publications_2022 = "Publications in 2022"
legend_labels = ["Type A", "Type B", "Type C"]
fig_title = "Philosophical School Publications Over Two Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the bars
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]
width = 0.3
xlim_value = (0, 400)
xticks_value = [0, 50, 100, 150, 200, 250, 300, 350, 400]
yticks_value = schools
fontsize_title = 16

# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 7), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, schools, colors):
    bottom = np.zeros(len(schools))
    for i in range(counts.shape[1]):
        ax.barh(
            schools, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for Publications in 2021
plot_stacked_bars(ax1, counts_publications_2021, schools, colors)
ax1.set_title(title_publications_2021, y=1.2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with style
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for Publications in 2022
plot_stacked_bars(ax2, counts_publications_2022, schools, colors)
ax2.set_title(title_publications_2022)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with style
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_128.pdf", bbox_inches="tight")

