
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
court_types = ["Criminal", "Civil", "Family", "Labor"]
Cases_2018 = [150, 300, 200, 100]
Cases_2019 = [160, 310, 210, 110]
Cases_2020 = [170, 320, 220, 120]
Cases_2021 = [180, 330, 230, 130]
Cases_2022 = [190, 340, 240, 140]

barWidth = 0.15
r1 = np.arange(len(Cases_2018))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["2018", "2019", "2020", "2021", "2022"]
ylabel = "Number of Cases"
xlabel = "Court Types"
title = "Number of Legal Cases Handled Over Years"
legendlabels = ["2018", "2019", "2020", "2021", "2022"]
ylim = [0, 400]
yticks = [0, 100, 200, 300, 400]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure
plt.figure(figsize=(10, 6))  # Adjusted dimensions

# Create bars with new color scheme
plt.bar(r1, Cases_2018, color="#004c6d", width=barWidth, edgecolor="black", label=legendlabels[0])
plt.bar(r2, Cases_2019, color="#1f78b4", width=barWidth, edgecolor="black", label=legendlabels[1])
plt.bar(r3, Cases_2020, color="#a6cee3", width=barWidth, edgecolor="black", label=legendlabels[2])
plt.bar(r4, Cases_2021, color="#fdbf6f", width=barWidth, edgecolor="black", label=legendlabels[3])
plt.bar(r5, Cases_2022, color="#e31a1c", width=barWidth, edgecolor="black", label=legendlabels[4])

# Add xticks on the middle of the group bars
plt.xticks([r + barWidth * 2 for r in range(len(Cases_2018))], court_types)

# Create legend & Show graphic
plt.legend(loc="upper left")
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(yticks)
plt.grid(axis='y', linestyle='--', linewidth=0.7, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_134.pdf", bbox_inches="tight")
