

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Dataset for Society Domain
categories = [
    "Group A vs. Group B",
    "Group A vs. Group C",
    "Group A vs. Group D",
    "Group A vs. Group E",
    "Group B vs. Group C",
    "Group B vs. Group D",
    "Group B vs. Group E",
    "Group C vs. Group D",
]

# New plausible win, tie, lose data
group_win = [34.5, 29.0, 38.7, 41.2, 28.5, 36.8, 33.4, 39.9]
tie = [40.3, 45.2, 36.3, 30.4, 42.8, 38.3, 37.0, 34.5]
group_lose = [25.2, 25.8, 25.0, 28.4, 28.7, 24.9, 29.6, 25.6]

# Text contents
textcontent = "Group Performance Comparison on Various Social Metrics"
suptitle = "Comparison of Different Social Groups"
legendlabels = ["Group win", "Tie", "Group lose"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot
fig, ax = plt.subplots(figsize=(10, 8))

bar_width = 0.5  # Adjusted bar width for readability
bar_spacing = 0.1  # Adjusted spacing between bars

for i, category in enumerate(categories):
    ax.barh(category, group_win[i], height=bar_width, color=colors[0])
    ax.barh(category, tie[i], height=bar_width, left=group_win[i], color=colors[1])
    ax.barh(
        category,
        group_lose[i],
        height=bar_width,
        left=group_win[i] + tie[i],
        color=colors[2],
    )
    ax.text(
        5,
        category,
        f"{group_win[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        group_win[i] + tie[i] / 2,
        category,
        f"{tie[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        95,
        category,
        f"{group_lose[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )

# Remove spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

# Remove x-axis
ax.xaxis.set_visible(False)

# Adjust y-axis
ax.invert_yaxis()

# Add label below the x-axis
plt.figtext(
    0.5,
    0.01,
    textcontent,
    ha="center",
    fontsize=10,
)

# Add Suptitle
plt.suptitle(suptitle, fontsize=14)

# Legend
ax.legend(
    legendlabels,
    loc="upper center",
    ncol=3,
    fontsize=12,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_135.pdf", bbox_inches="tight")

