
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Existentialism",
    "Stoicism",
    "Utilitarianism",
    "Nihilism",
    "Rationalism",
    "Empiricism",
    "Absurdism",
    "Transcendentalism"
]
positive_impact = [50, 30, 60, 20, 70, 55, 25, 45]
neutral_impact = [30, 40, 20, 35, 20, 30, 45, 35]
negative_impact = [20, 30, 20, 45, 10, 15, 30, 20]
textcontent = "Philosophical Movements and Their Impact on Modern Thought"
legendlabels = ["Positive Impact", "Neutral Impact", "Negative Impact"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 8))  # Adjusted figure size for better readability
# Colors
colors = ["#76c7c0", "#ffbb78", "#d62728"]

bar_width = 0.6  # Width of bars
bar_spacing = 0.3  # Spacing between bars

for i, category in enumerate(categories):
    ax.barh(category, positive_impact[i], height=bar_width, color=colors[0])
    ax.barh(category, neutral_impact[i], height=bar_width, left=positive_impact[i], color=colors[1])
    ax.barh(category, negative_impact[i], height=bar_width, left=positive_impact[i] + neutral_impact[i], color=colors[2])
    ax.text(positive_impact[i] / 2, category, f"{positive_impact[i]}%", ha="center", va="center", color="white", fontsize=10)
    ax.text(positive_impact[i] + neutral_impact[i] / 2, category, f"{neutral_impact[i]}%", ha="center", va="center", color="white", fontsize=10)
    ax.text(positive_impact[i] + neutral_impact[i] + negative_impact[i] / 2, category, f"{negative_impact[i]}%", ha="center", va="center", color="white", fontsize=10)

# Remove spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

# Remove x-axis
ax.xaxis.set_visible(False)

# Adjust y-axis
ax.invert_yaxis()

# Add label below the x-axis
plt.figtext(0.5, 0.01, textcontent, ha="center", fontsize=12, fontweight='bold')

# Legend
ax.legend(legendlabels, loc="upper center", ncol=3, fontsize=12, bbox_to_anchor=(0.5, 1.05))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_137.pdf", bbox_inches="tight")
