
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["Miami", "Seattle", "Denver", "San Francisco", "Boston"]
sunny_days = [250, 60, 245, 160, 200]
rainy_days = [90, 220, 45, 80, 100]
snowy_days = [25, 85, 75, 125, 65]

indices = range(len(categories))

# Text labels for the chart
xlabel = "Number of Days"
ylabel = "Cities"
title = "Annual Weather Conditions Across Cities"
legend_labels = ["Sunny Days", "Rainy Days", "Snowy Days"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5

# Figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars1 = ax.barh(indices, sunny_days, bar_width, label=legend_labels[0], color="#2ca02c")
bars2 = ax.barh(indices, rainy_days, bar_width, left=sunny_days, label=legend_labels[1], color="#ff7f0e")
bars3 = ax.barh(indices, snowy_days, bar_width, left=[i + j for i, j in zip(sunny_days, rainy_days)], label=legend_labels[2], color="#d62728")

# Adding text labels with positions and font size
for i, bar in enumerate(bars1):
    ax.text(bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{sunny_days[i]} days", ha="center", va="center", color="white", fontsize=14)
for i, bar in enumerate(bars2):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{rainy_days[i]} days", ha="center", va="center", color="black", fontsize=14)
for i, bar in enumerate(bars3):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{snowy_days[i]} days", ha="center", va="center", color="black", fontsize=14)

# Labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)
ax.set_yticks(indices)
ax.set_yticklabels(categories, fontsize=14)
ax.invert_yaxis()  # Labels read top-to-bottom
ax.set_xticks([])

# Legend with new position
ax.legend(loc="upper left", bbox_to_anchor=(0.1, 1.15), ncol=3, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Tight layout
plt.tight_layout()
plt.savefig("bar_138.pdf", bbox_inches="tight")
