
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["YouTube", "Facebook", "Twitter", "Instagram", "TikTok"]
likes = [150, 120, 100, 170, 130]
shares = [80, 90, 70, 65, 75]
comments = [60, 40, 30, 45, 60]
indices = range(len(categories))

# Labels
labels = ["Likes", "Shares", "Comments"]
xlabel = "Number of Engagements"
ylabel = "Media Platforms"
title = "User Engagement Across Media Platforms"
supertitle = "Media User Engagement Analysis"
annotation_texts = [likes, shares, comments]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
colors = ["#b5651d", "#f4a460", "#d2b48c"]

# Figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars1 = ax.barh(indices, likes, bar_width, label=labels[0], color=colors[0])
bars2 = ax.barh(indices, shares, bar_width, left=likes, label=labels[1], color=colors[1])
bars3 = ax.barh(indices, comments, bar_width, left=[i + j for i, j in zip(likes, shares)], label=labels[2], color=colors[2])

# Adding text labels
for i, bar in enumerate(bars1):
    ax.text(bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{likes[i]}", ha="center", va="center", color="white", fontsize=12)
for i, bar in enumerate(bars2):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{shares[i]}", ha="center", va="center", color="black", fontsize=12)
for i, bar in enumerate(bars3):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{comments[i]}", ha="center", va="center", color="black", fontsize=12)

# Labels and title
ax.set_yticks(indices)
ax.set_yticklabels(categories, fontsize=14)
ax.invert_yaxis()  # Labels read top-to-bottom
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Legend
ax.legend(loc="upper left", bbox_to_anchor=(0.1, 1.17), ncol=3, fontsize=14)

# Supertitle
plt.suptitle(supertitle, fontsize=18)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_139.pdf", bbox_inches="tight")
