
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Customer Satisfaction - Financial Service Company A
company_a_data = {
    "Customer Service": [18, 22, 35, 15, 10],
    "Online Experience": [12, 20, 30, 28, 10],
    "Product Offerings": [10, 25, 40, 20, 5],
    "Value for Money": [14, 24, 30, 22, 10],
}
company_a_data2 = {
    "Overall Satisfaction": [16, 28, 30, 16, 10],
}

# Data for Customer Satisfaction - Financial Service Company B
company_b_data = {
    "Customer Service": [15, 25, 30, 20, 10],
    "Online Experience": [10, 25, 35, 20, 10],
    "Product Offerings": [8, 20, 42, 20, 10],
    "Value for Money": [12, 24, 35, 19, 10],
}
company_b_data2 = {"Overall Satisfaction": [18, 26, 28, 18, 10]}

categories = ["Very Unsatisfied", "Unsatisfied", "Neutral", "Satisfied", "Very Satisfied"]
categories2 = ["Very Low", "Low", "Neutral", "High", "Very High"]

# Chart text labels
title_a = "Customer Satisfaction - Company A"
title_b = "Customer Satisfaction - Company B"
legend_labels = ["Very Unsatisfied", "Unsatisfied", "Neutral", "Satisfied", "Very Satisfied"]

labels = ["Company A", "Company B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#67a9cf", "#ef8a62", "white", "#67a9cf", "#2166ac"]
xlim = [-60, 60]
xticks = np.arange(-50, 51, 20)

# Create a gridspec
gs = gridspec.GridSpec(
    3, 2, height_ratios=[1.2, 0.2, 0.2]
)  # Adjust the height ratios for each row

fig = plt.figure(figsize=(12, 7))

# Create axes using the gridspec
axes = [plt.subplot(gs[0, 0]), plt.subplot(gs[0, 1])]


def create_bar_chart(ax, results, category_names, title):

    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = plt.get_cmap("viridis")(np.linspace(0.15, 0.85, data.shape[1]))

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )
        for j, (start, width) in enumerate(zip(starts, widths)):
            # Calculate the center position of each bar segment for the text
            text_x = start + width / 2
            text_y = j  # y-coordinate is based on the bar's index (j)
            ax.text(
                text_x,
                text_y,
                f"{abs(width):.1f}%",
                va="center",
                ha="center",
                color="black",
                fontsize=8,
            )
    # Add Zero Reference Line
    ax.axvline(0, linestyle="-", color="black", alpha=0.25)
    # X Axis
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))
    # Y Axis
    ax.invert_yaxis()
    ax.set_title(title)


# Create bar charts for Company A and Company B
create_bar_chart(axes[0], company_a_data, categories, title_a)
create_bar_chart(axes[1], company_b_data, categories2, title_b)


# Add legend
handles, labels = axes[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=len(categories),
    bbox_to_anchor=(0.5, 0.25),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_143.pdf", bbox_inches="tight")
