

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New data for the weather analysis domain
temperature_values = np.linspace(-10, 40, 11)
humidity_values = np.linspace(10, 100, 11)
wind_speed_values = np.linspace(0, 50, 11)

# Sample performance change rates for 'Urban Area' and 'Rural Area'
performance_change_temperature_urban = np.random.uniform(-5, 15, 11)
performance_change_humidity_urban = np.random.uniform(-10, 20, 11)
performance_change_wind_speed_urban = np.random.uniform(-20, 10, 11)

performance_change_temperature_rural = np.random.uniform(-10, 10, 11)
performance_change_humidity_rural = np.random.uniform(-5, 25, 11)
performance_change_wind_speed_rural = np.random.uniform(-15, 15, 11)

# Labels and axis descriptions
label_urban = "Urban Area"
label_rural = "Rural Area"
xlabel_temperature = "Temperature [°C]"
ylabel_performance_change = "Performance Change [%]"
xlabel_humidity = "Humidity [%]"
xlabel_wind_speed = "Wind Speed [km/h]"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_temperature = (-10, 20)
xlim_temperature = (-11, 41)
yticks_temperature = [-10, 0, 10, 20]
xticks_temperature = [-10, 0, 10, 20, 30, 40]
ylim_humidity = (-10, 30)
xlim_humidity = (8, 102)
yticks_humidity = [-10, 0, 10, 20, 30]
xticks_humidity = [10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
ylim_wind_speed = (-25, 15)
xlim_wind_speed = (-2, 52)
yticks_wind_speed = [-20, -10, 0, 10]
xticks_wind_speed = [0, 10, 20, 30, 40, 50]

# Create figure and subplots
fig, axs = plt.subplots(3, 1, figsize=(6, 10))

# Top chart - Temperature
axs[0].bar(
    temperature_values - 1,
    performance_change_temperature_urban,
    width=2,
    zorder=10,
    color="#e377c2",  # Vibrant pink for urban area
    label=label_urban,
)
axs[0].bar(
    temperature_values + 1,
    performance_change_temperature_rural,
    width=2,
    zorder=10,
    color="#7f7f7f",  # Subtle grey for rural area
    label=label_rural,
)
axs[0].set_xlabel(xlabel_temperature)
axs[0].set_ylabel(ylabel_performance_change)
axs[0].set_ylim(ylim_temperature)
axs[0].set_xlim(xlim_temperature)
axs[0].set_yticks(yticks_temperature)
axs[0].xaxis.set_major_locator(ticker.FixedLocator(xticks_temperature))
axs[0].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks2 = [-11] + [i + 5 for i in xticks_temperature]
axs[0].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks2))
axs[0].grid(True, which="minor", axis="x", color="gray")
axs[0].grid(True, which="major", axis="y", color="gray")
axs[0].tick_params(axis="x", which="major", length=0)

# Middle chart - Humidity
axs[1].bar(
    humidity_values - 1,
    performance_change_humidity_urban,
    width=2,
    zorder=10,
    color="#1f77b4",  # Blue for urban area
)
axs[1].bar(
    humidity_values + 1,
    performance_change_humidity_rural,
    width=2,
    zorder=10,
    color="#ff7f0e",  # Orange for rural area
)
axs[1].set_xlabel(xlabel_humidity)
axs[1].set_ylabel(ylabel_performance_change)
axs[1].set_ylim(ylim_humidity)
axs[1].set_xlim(xlim_humidity)
axs[1].set_yticks(yticks_humidity)
axs[1].xaxis.set_major_locator(ticker.FixedLocator(xticks_humidity))
axs[1].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks1 = [8] + [i + 5 for i in xticks_humidity]
axs[1].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks1))
axs[1].grid(True, which="minor", axis="x", color="gray")
axs[1].grid(True, which="major", axis="y", color="gray")
axs[1].tick_params(axis="x", which="major", length=0)

# Bottom chart - Wind Speed
axs[2].bar(
    wind_speed_values - 1,
    performance_change_wind_speed_urban,
    width=2,
    zorder=10,
    color="#2ca02c",  # Green for urban area
)
axs[2].bar(
    wind_speed_values + 1,
    performance_change_wind_speed_rural,
    width=2,
    zorder=10,
    color="#d62728",  # Red for rural area
)
axs[2].set_xlabel(xlabel_wind_speed)
axs[2].set_ylabel(ylabel_performance_change)
axs[2].set_ylim(ylim_wind_speed)
axs[2].set_xlim(xlim_wind_speed)
axs[2].set_yticks(yticks_wind_speed)
axs[2].tick_params(axis="x", which="major", length=0)

axs[2].xaxis.set_major_locator(ticker.FixedLocator(xticks_wind_speed))
axs[2].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
offsetticks = [-2] + [i + 5 for i in xticks_wind_speed]
axs[2].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks))
axs[2].grid(True, which="minor", axis="x", color="gray")
axs[2].grid(True, which="major", axis="y", color="gray")

# Add legend
fig.legend(loc="upper center", ncol=2, bbox_to_anchor=(0.5, 1.03), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_146.pdf", bbox_inches="tight")
