
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
art_styles = ["Impressionism", "Cubism", "Surrealism", "Abstract", "Realism", "Pop Art"]
use_of_color = [4.5, 4.3, 4.7, 4.8, 4.2, 4.6]
composition = [4.4, 4.2, 4.5, 4.0, 4.7, 4.3]
creativity = [4.3, 4.6, 4.8, 4.5, 4.1, 4.7]
popularity = [4.6, 4.1, 4.2, 4.3, 4.4, 4.5]

x = np.arange(len(art_styles))  # the label locations

labels = ["Use of Color", "Composition", "Creativity", "Popularity"]
ylabel = "Ratings"
xlabel = "Art Styles"
title = "Ratings of Different Art Styles on a Scale from 1-5"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Color scheme for art domain
colors = ["#8c564b", "#2ca02c", "#1f77b4", "#ff7f0e"]

# Plotting
rects1 = ax.bar(x - width * 1.5, use_of_color, width, label=labels[0], color=colors[0])
rects2 = ax.bar(x - width / 2, composition, width, label=labels[1], color=colors[1])
rects3 = ax.bar(x + width / 2, creativity, width, label=labels[2], color=colors[2])
rects4 = ax.bar(x + width * 1.5, popularity, width, label=labels[3], color=colors[3])

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylim(0, 6)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(x)
ax.set_xticklabels(art_styles, rotation=15, ha='right', fontsize=10)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_147.pdf", bbox_inches="tight")
