
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
categories = ["Region A", "Region B", "Region C", "Region D"]
goals_scored = [55.1, 48.3, 38.9, 45.4]
draws = [20.2, 15.8, 25.0, 24.1]
goals_conceded = [24.7, 35.9, 36.1, 30.5]

# Repeat for the second subplot with different data
goals_scored2 = [50.6, 49.5, 42.8, 48.9]
draws2 = [18.4, 16.3, 22.5, 19.8]
goals_conceded2 = [31.0, 34.2, 34.7, 31.3]

indices = np.arange(len(categories))

xlabel = "Season 2022 Performance"
xlabel2 = "Season 2023 Performance"

labels = [
    "High Scorers",
    "Moderate Scorers",
    "Consistent Draws",
    "Fluctuating Performances",
    "High Conceders",
    "Very High Conceders",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
colors_wins = ["#4CAF50", "#4CAF50", "#4CAF50", "#FF9800"]
colors_ties = ["#81C784", "#81C784", "#81C784", "#FFB74D"]
colors_losses = ["#C8E6C9", "#C8E6C9", "#C8E6C9", "#FFCC80"]

# Plot data
bar_width = 0.5

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Function to plot bars
def plot_bars(ax, goals_scored, draws, goals_conceded, colors_wins, colors_ties, colors_losses):
    for i, (scored, draw, conceded) in enumerate(zip(goals_scored, draws, goals_conceded)):
        ax.barh(i, scored, bar_width, color=colors_wins[i], edgecolor="white")
        ax.barh(i, draw, bar_width, left=scored, color=colors_ties[i], edgecolor="white")
        ax.barh(
            i,
            conceded,
            bar_width,
            left=scored + draw,
            color=colors_losses[i],
            edgecolor="white",
        )
        ax.text(scored / 2, i, f"{scored}%", ha="center", va="center", color="white")
        ax.text(scored + draw / 2, i, f"{draw}%", ha="center", va="center", color="black")
        ax.text(
            scored + draw + conceded / 2, i, f"{conceded}%", ha="center", va="center", color="black"
        )

plot_bars(ax1, goals_scored, draws, goals_conceded, colors_wins, colors_ties, colors_losses)

# Set labels, title, and legend for ax1
ax1.set_yticks(indices)
ax1.set_yticklabels(categories)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_xlabel(xlabel)
ax1.set_xticks([])

plot_bars(ax2, goals_scored2, draws2, goals_conceded2, colors_wins, colors_ties, colors_losses)

# Set labels, title, and legend for ax2
ax2.set_yticks(indices)
ax2.set_yticklabels(categories)
ax2.invert_yaxis()  # labels read top-to-bottom
ax2.set_xlabel(xlabel2)
ax2.set_xticks([])

# Adjust layout and set background color
fig.patch.set_facecolor("white")
for ax in [ax1, ax2]:
    ax.set_facecolor("white")
    ax.spines["top"].set_edgecolor("gray")
    ax.spines["right"].set_edgecolor("gray")
    ax.spines["bottom"].set_edgecolor("gray")
    ax.spines["left"].set_edgecolor("gray")

# Create a global legend
patch1 = mpatches.Patch(color="#FF9800", label=labels[0])
patch2 = mpatches.Patch(color="#4CAF50", label=labels[1])
patch3 = mpatches.Patch(color="#FFB74D", label=labels[2])
patch4 = mpatches.Patch(color="#81C784", label=labels[3])
patch5 = mpatches.Patch(color="#FFCC80", label=labels[4])
patch6 = mpatches.Patch(color="#C8E6C9", label=labels[5])
fig.legend(
    handles=[patch1, patch2, patch3, patch4, patch5, patch6],
    loc="upper center",
    ncol=3,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_154.pdf", bbox_inches="tight")
