
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["Sales", "Marketing", "Development", "HR"]
positive = [75.3, 60.2, 80.8, 55.3]
neutral = [15.2, 25.8, 10.4, 30.7]
negative = [9.5, 14.0, 8.8, 14.0]

# Repeat for the second subplot with slightly varied data
positive2 = [78.1, 62.6, 82.4, 57.1]
neutral2 = [14.4, 26.1, 9.1, 28.9]
negative2 = [7.5, 11.3, 8.5, 14.0]

indices = np.arange(len(categories))

xlabel = "Corporate Performance Metrics - Q1"
xlabel2 = "Corporate Performance Metrics - Q2"

labels = [
    "High Performance",
    "Satisfactory Performance",
    "Low Performance"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
colors_positive = ["#6b8f71", "#6b8f71", "#6b8f71", "#5c8a5a"]
colors_neutral = ["#a6b1a5", "#a6b1a5", "#a6b1a5", "#a2b5a6"]
colors_negative = ["#d9534f", "#d9534f", "#d9534f", "#c9302c"]

# Plot data
bar_width = 0.5

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Function to plot bars
def plot_bars(ax, positive, neutral, negative, colors_positive, colors_neutral, colors_negative):
    for i, (pos, neu, neg) in enumerate(zip(positive, neutral, negative)):
        ax.barh(i, pos, bar_width, color=colors_positive[i], edgecolor="white")
        ax.barh(i, neu, bar_width, left=pos, color=colors_neutral[i], edgecolor="white")
        ax.barh(i, neg, bar_width, left=pos + neu, color=colors_negative[i], edgecolor="white")
        ax.text(pos / 2, i, f"{pos}", ha="center", va="center", color="white")
        ax.text(pos + neu / 2, i, f"{neu}", ha="center", va="center", color="black")
        ax.text(pos + neu + neg / 2, i, f"{neg}", ha="center", va="center", color="black")

plot_bars(ax1, positive, neutral, negative, colors_positive, colors_neutral, colors_negative)

# Set labels, title, and legend for ax1
ax1.set_yticks(indices)
ax1.set_yticklabels(categories)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_xlabel(xlabel)
ax1.set_xticks([])

plot_bars(ax2, positive2, neutral2, negative2, colors_positive, colors_neutral, colors_negative)

# Set labels, title, and legend for ax2
ax2.set_yticks(indices)
ax2.set_yticklabels(categories)
ax2.invert_yaxis()  # labels read top-to-bottom
ax2.set_xlabel(xlabel2)
ax2.set_xticks([])

# Adjust layout and set background color
fig.patch.set_facecolor("white")
for ax in [ax1, ax2]:
    ax.set_facecolor("white")
    ax.spines["top"].set_edgecolor("gray")
    ax.spines["right"].set_edgecolor("gray")
    ax.spines["bottom"].set_edgecolor("gray")
    ax.spines["left"].set_edgecolor("gray")

# Create a global legend
patch1 = mpatches.Patch(color="#6b8f71", label=labels[0])
patch2 = mpatches.Patch(color="#a6b1a5", label=labels[1])
patch3 = mpatches.Patch(color="#d9534f", label=labels[2])
fig.legend(
    handles=[patch1, patch2, patch3],
    loc="upper center",
    ncol=3,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_155.pdf", bbox_inches="tight")
