
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
political_issues = ["HC", "Econ", "Edu", "Env", "Immig", "Sec", "Trade", "Tech"]
negative = [0, 0, 0, 0, 800, 0, 0, 0]
positive = [0, 0, 0, 400, 0, 0, 0, 0]
neutral = [0, 0, 0, 0, 0, 0, 0, 200]
mixed = [200, 100, 150, 0, 0, 300, 400, 0]
# Updated politics-related labels
labels = ["Negative", "Positive", "Neutral", "Mixed"]
xlabel = "Political Issues"
ylabel = "Sentiment Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 1000]

# Set figure size to match the original image's dimensions
plt.figure(figsize=(6, 4))

# Plotting
bar_width = 0.8
index = np.arange(len(political_issues))

plt.bar(index, negative, bar_width, color="#FF9999", label=labels[0])  # 用较浅的红色
plt.bar(index, positive, bar_width, color="#8FD9B6", label=labels[1], bottom=negative)  # 使用绿松石色
plt.bar(
    index,
    neutral,
    bar_width,
    color="#CCCCCC",  # 使用灰色
    label=labels[2],
    bottom=[i + j for i, j in zip(negative, positive)],
)
plt.bar(
    index,
    mixed,
    bar_width,
    color="#FFD700",  # 使用金色
    label=labels[3],
    bottom=[i + j + k for i, j, k in zip(negative, positive, neutral)],
)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(index, political_issues)
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_156.pdf", bbox_inches="tight")
