

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
sectors = ["Electronics", "Clothing", "Home Goods", "Books"]
spring_sales = [1500, 0, 0, 0]
summer_sales = [0, 1800, 0, 0]
fall_sales = [0, 0, 900, 0]
winter_sales = [0, 0, 0, 700]
labels = ["Spring Sales", "Summer Sales", "Fall Sales", "Winter Sales"]

# Labels and Titles
xlabel = "Product Categories"
ylabel = "Sales Volume (in units)"
title = "Sales Volume by Category and Season"
legend_labels = ["Spring Sales", "Summer Sales", "Fall Sales", "Winter Sales"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 5000]

# Set figure size to be more visually balanced
plt.figure(figsize=(8, 6))

# Plotting
bar_width = 0.8
index = np.arange(len(sectors))

# Color choices
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

plt.bar(index, spring_sales, bar_width, color=colors[0], label=labels[0])
plt.bar(index, summer_sales, bar_width, color=colors[1], label=labels[1], bottom=spring_sales)
plt.bar(
    index,
    fall_sales,
    bar_width,
    color=colors[2],
    label=labels[2],
    bottom=[i + j for i, j in zip(spring_sales, summer_sales)],
)
plt.bar(
    index,
    winter_sales,
    bar_width,
    color=colors[3],
    label=labels[3],
    bottom=[i + j + k for i, j, k in zip(spring_sales, summer_sales, fall_sales)],
)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.ylim(ylim)
plt.xticks(index, sectors)
plt.legend(legend_labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_158.pdf", bbox_inches="tight")
