

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New Data
datasets = ["Urban Area", "Rural Area"]
emissions_co2 = [15.2, 5.8]
water_consumption = [120.0, 85.5]
energy_usage = [50.0, 30.2]

# X-axis positions
x = np.arange(len(datasets))

# Labels and Titles
labels = ["CO2 Emissions", "Water Consumption", "Energy Usage"]
ylabel = "Measurements"
xlabel = "Scenarios"
title = "Environmental Impact Across Different Areas"
legendlocation = "upper left"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [0, 160.0]

# Color Scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plotting
fig, ax = plt.subplots(figsize=(6, 5))

ax.bar(
    x - width,
    emissions_co2,
    width,
    label=labels[0],
    hatch="//",
    edgecolor="black",
    color=colors[0],
)
ax.bar(
    x,
    water_consumption,
    width,
    label=labels[1],
    hatch="..",
    edgecolor="black",
    color=colors[1],
)
ax.bar(
    x + width,
    energy_usage,
    width,
    label=labels[2],
    hatch="xx",
    edgecolor="black",
    color=colors[2],
)

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(datasets)
ax.legend(loc=legendlocation)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_162.pdf", bbox_inches="tight")

