

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
datasets = ["January", "July"]
email = [150, 200]
phone = [100, 80]
video_call = [75, 120]

# X-axis positions
x = np.arange(len(datasets))


labels = ["Email", "Phone", "Video Call"]

ylabel = "Usage (Hours)"
xlabel = "Months"
title = "Monthly Communication Tool Usage"
legend_labels = ["Email", "Phone", "Video Call"]
legendtitle="Communication Tool"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [0, 250]


# Plotting
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusting figure size to be larger for better readability
ax.bar(
    x - width,
    email,
    width,
    label=labels[0],
    hatch="//",
    edgecolor="black",
    color="darkgray",
)
ax.bar(
    x,
    phone,
    width,
    label=labels[1],
    hatch="..",
    edgecolor="black",
    color="yellow",
)
ax.bar(
    x + width,
    video_call,
    width,
    label=labels[2],
    hatch="xx",
    edgecolor="black",
    color="green",
)

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(datasets)
ax.legend(loc="upper left", title=legendtitle)

# Title
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_163.pdf", bbox_inches="tight")

