

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data: Average daily screen time (hours) by age group
age_groups = ["Children", "Teens", "Young Adults", "Adults", "Seniors"]
tv = [2, 1.5, 1, 1.5, 2]
smartphones = [1, 3, 4, 2, 1]
computers = [0.5, 2, 3, 3, 0.5]

x = np.arange(len(age_groups))  # the label locations

# Labels for legend
label_tv = "TV"
label_smartphones = "Smartphones"
label_computers = "Computers"

# Axis labels
xlabel = "Age Groups"
ylabel = "Average Daily Screen Time (Hours)"

# Chart Title
title = "Average Daily Screen Time by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.25  # the width of the bars
# Axis ticks
xticks = x
yticks = [0, 1, 2, 3, 4]

# Axis tick labels
xticklabels = age_groups
yticklabels = ["0", "1", "2", "3", "4"]

fig, ax = plt.subplots(figsize=(10, 6))
rects1 = ax.bar(x - width, tv, width, label=label_tv, color="#707070")
rects2 = ax.bar(x, smartphones, width, label=label_smartphones, color="#1f77b4")
rects3 = ax.bar(x + width, computers, width, label=label_computers, color="#2ca02c")

ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_title(title)

# Set custom y-ticks and their labels
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

ax.legend(ncol=3, loc="upper center", bbox_to_anchor=(0.5, 1.1), frameon=False)

ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_166.pdf", bbox_inches="tight")

