
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
countries = ["Country X", "Country Y", "Country Z"]
tourist_arrivals_2019 = [450, 520, 600]
tourist_arrivals_2020 = [300, 410, 470]
tourist_arrivals_2021 = [500, 580, 650]

# X-axis positions
x = np.arange(len(countries))

# Labels and titles
labels = ["2019", "2020", "2021"]
ylabel = "Number of Tourist Arrivals (in thousands)"
xlabel = "Countries"
title = "Tourist Arrivals by Year and Country"
legend_labels = labels
annotation_texts = lambda height: f"{height}k"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2
gap_width = 0.02

# Plotting bars
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to match 468x360 pixels
rects1 = ax.bar(
    x - bar_width - gap_width, tourist_arrivals_2019, bar_width, label=labels[0], color="#8ecae6"
)
rects2 = ax.bar(x, tourist_arrivals_2020, bar_width, label=labels[1], color="#219ebc")
rects3 = ax.bar(
    x + bar_width + gap_width, tourist_arrivals_2021, bar_width, label=labels[2], color="#023047"
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(countries)
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, fontsize=8)

# Adding data labels inside the bars
def autolabel(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            annotation_texts(height),
            xy=(rect.get_x() + rect.get_width() / 2, height + 2),
            xytext=(0, 0),  # No offset
            textcoords="offset points",
            ha="center",
            va="center",
            color="black",
            fontsize=8,
        )

autolabel(rects1)
autolabel(rects2)
autolabel(rects3)

# Adjusting the layout and font sizes
ax.tick_params(axis="x", labelsize=8)
ax.tick_params(axis="y", labelsize=8)
ax.yaxis.label.set_size(8)
ax.xaxis.label.set_size(8)
ax.title.set_size(10)

# Adding grid
ax.grid(axis="y", linestyle="--", alpha=0.6)
ax.grid(axis="x", linestyle="--", alpha=0.6)
ax.set_axisbelow(True)

plt.subplots_adjust(bottom=0.25, top=0.90)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_168.pdf", bbox_inches="tight")
