
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data: Efficiency rates of different renewable energy sources under various weather conditions
energy_sources = ["Solar", "Wind", "Hydro"]
sunny = [85.0, 70.3, 60.5]
windy = [70.1, 90.4, 75.6]
rainy = [55.5, 80.2, 95.8]

# X-axis positions
x = np.arange(len(energy_sources))

# Labels and other textual elements
labels = ["Sunny", "Windy", "Rainy"]
ylabel = "Efficiency Rate (%)"
xlabel = "Renewable Energy Sources"
title = "Efficiency Rates of Renewable Energy Sources"
legendlabels = ["Sunny", "Windy", "Rainy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2
gap_width = 0.02

# Plotting bars
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to match 468x360 pixels
rects1 = ax.bar(
    x - bar_width - gap_width, sunny, bar_width, label=labels[0], color="#FF6F61"
)
rects2 = ax.bar(x, windy, bar_width, label=labels[1], color="#6B5B95")
rects3 = ax.bar(
    x + bar_width + gap_width, rainy, bar_width, label=labels[2], color="#88B04B"
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(energy_sources)
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=3)

# Adding data labels inside the bars
def autolabel(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height + 2),
            xytext=(0, 0),  # No offset
            textcoords="offset points",
            ha="center",
            va="center",
            color="black",
            fontsize=8,
        )

autolabel(rects1)
autolabel(rects2)
autolabel(rects3)

# Adjusting the layout and font sizes
ax.tick_params(axis="x", labelsize=8)
ax.tick_params(axis="y", labelsize=8)
ax.yaxis.label.set_size(8)

# Adding grid
ax.grid(axis="y", linestyle="--", alpha=0.6)
ax.grid(axis="x", linestyle="--", alpha=0.6)
ax.set_axisbelow(True)

plt.subplots_adjust(bottom=0.2, top=0.95)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_170.pdf", bbox_inches="tight")
