
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Text Labels
xlabel = "Percentage of Energy Usage"
ylabel = "Industry Comparisons"
title = "Energy Usage Comparisons Among Industries"
legend_labels = ["High Usage", "Moderate Usage", "Low Usage"]
categories = [
    "Industry A vs. Industry B",
    "Industry A vs. Industry C",
    "Industry B vs. Industry C",
    "Industry A vs. Industry D",
    "Industry B vs. Industry D",
    "Industry C vs. Industry D",
][::-1]
high_usage = [50.0, 45.0, 60.0, 55.0, 65.0, 70.0][::-1]
moderate_usage = [30.0, 35.0, 25.0, 30.0, 20.0, 15.0][::-1]
low_usage = [20.0, 20.0, 15.0, 15.0, 15.0, 15.0][::-1]

# Bar configuration
bar_width = 0.6
indices = range(len(categories))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size

# Colors
colors = ["#4CAF50", "#FFC107", "#F44336"]

bars1 = ax.barh(indices, high_usage, bar_width, label=legend_labels[0], color=colors[0])
bars2 = ax.barh(indices, moderate_usage, bar_width, left=high_usage, label=legend_labels[1], color=colors[1])
bars3 = ax.barh(indices, low_usage, bar_width, left=[i + j for i, j in zip(high_usage, moderate_usage)], label=legend_labels[2], color=colors[2])

# Add text labels to the bars
for bars, color in zip([bars1, bars2, bars3], colors):
    for bar in bars:
        width = bar.get_width()
        center = bar.get_x() + width / 2
        ax.text(center, bar.get_y() + bar.get_height() / 2, f"{width:.1f}%", va="center", ha="center", color="black", fontsize=10)

# Set labels and title
ax.set_yticks(indices)
ax.set_yticklabels(categories, ha="right", fontsize=12)

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the x-axis labels
xticks = np.arange(0, 101, 20)
xtickslabel = [str(x) for x in xticks]
ax.set_xticks(xticks)
ax.set_xticklabels(xtickslabel)

# Add legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, -0.10), shadow=True, ncol=3, frameon=False)

# Remove spines
for spine in ["top", "right"]:
    ax.spines[spine].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_173.pdf", bbox_inches="tight")
