

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
months = ["Jan", "Feb", "Mar", "Apr", "May"]
church_a_attendance = [120, 135, 150, 145, 160]  # Attendance at Church A
church_b_attendance = [80, 90, 100, 95, 110]     # Attendance at Church B
church_c_attendance = [50, 70, 60, 75, 85]       # Attendance at Church C

# X-axis positions for each group of bars
x = np.arange(len(months))

# Labels and Titles
labels = [
    "Church A Attendance",
    "Church B Attendance",
    "Church C Attendance",
]
title = "Monthly Church Attendance"
xlabel = "Months"
ylabel = "Number of Attendees"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.25

yticks = np.arange(0, 201, 40)

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Plotting bars
rects1 = ax.bar(
    x - bar_width,
    church_a_attendance,
    bar_width,
    label=labels[0],
    color="#4c72b0",  # Blue for Church A
    edgecolor="white",
)
rects2 = ax.bar(
    x,
    church_b_attendance,
    bar_width,
    label=labels[1],
    color="#dd8452",  # Orange for Church B
    edgecolor="white",
)
rects3 = ax.bar(
    x + bar_width,
    church_c_attendance,
    bar_width,
    label=labels[2],
    color="#55a868",  # Green for Church C
    edgecolor="white",
)

# Adding percentage labels on top of each bar
def add_labels(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            f"{height:.1f}",
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(rects1)
add_labels(rects2)
add_labels(rects3)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# X and Y ticks
ax.set_xticks(x)
ax.set_xticklabels(months)
ax.set_yticks(yticks)

# Legend
ax.legend(loc="upper left", ncol=1, frameon=False)

# Grid lines
ax.yaxis.grid(True)
ax.set_axisbelow(True)

grid_color = "#bdbdbd"
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)
# hidden ticks
plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_178.pdf", bbox_inches="tight")

