
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
regions = ["N. America", "Europe", "Asia", "S. America", "Africa"]
adoption_rates_t1 = [85, 77, 90, 60, 55]
adoption_rates_t2 = [75, 80, 88, 65, 50]

index = [6, 12]

# Labels for legend and plot type
labels = regions
# Limits, labels, and title for the plot
ylim_values = (0, 100)
ylabel_value = "Adoption Rate (%)"
xticks_values = index
xtickslabel_values = ["Tech1", "Tech2"]
title_value = "Adoption Rates of Technologies by Region"
legendlabels = ["N. America", "Europe", "Asia", "S. America", "Africa"]

# Bar width
bar_width = 1
# X-axis positions
r1 = np.arange(len(regions))
r2 = [x + bar_width + len(r1) for x in r1]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 5))
# Colors inspired by natural elements
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854"]

# Create bars
for i in range(len(r1)):
    plt.bar(
        index[0] + (i - 2) * bar_width,
        adoption_rates_t1[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i],
    )

for i in range(len(r2)):
    plt.bar(
        index[1] + (i - 2) * bar_width,
        adoption_rates_t2[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars
for i in range(len(r1)):
    plt.text(
        index[0] + (i - 2) * bar_width,
        adoption_rates_t1[i] + 1,
        str(adoption_rates_t1[i]),
        ha="center",
    )
    plt.text(
        index[1] + (i - 2) * bar_width,
        adoption_rates_t2[i] + 1,
        str(adoption_rates_t2[i]),
        ha="center",
    )

# General layout
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.ylim(*ylim_values)
plt.legend(legendlabels, loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.1), frameon=False)
plt.suptitle(title_value)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_184.pdf", bbox_inches="tight")

