
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
regions = [2, 4]  # Example of different geographical regions or categories
tourists_group1 = [75.6, 80.3]  # Hypothetical percentage values
tourists_group2 = [60.7, 65.8]
random_sampling = 70.0  # Random sampling baseline

labels = ["Region 1", "Region 2"]
xlabel = "Number of Regions"
ylabel = "Percentage of Tourists"
title = "Percentage of Tourists by Number of Regions"
axlabels = "Random Sampling Baseline"

ylim = [50, 90]  # Adjusted ylim based on the new data range

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(6.61, 5.23)
)  # Adjusted to match the original image's dimensions
bar_width = 0.35
index = np.arange(len(regions))

color_group1 = "#8ca3a3"
color_group2 = "#f2b38d"
baseline_color = "purple"
grid_color = "#d2d2d2"

bar1 = ax.bar(index, tourists_group1, bar_width, label=labels[0], color=color_group1)
bar2 = ax.bar(
    index + bar_width, tourists_group2, bar_width, label=labels[1], color=color_group2
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.2f" % height,
        ha="center",
        va="bottom",
    )

# Random Sampling Line
ax.axhline(y=random_sampling, color=baseline_color, linestyle="--", linewidth=1.5, label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)  # Added title
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(regions)
ax.legend(loc="upper right")  # Changed legend position
ax.yaxis.grid(True)
ax.set_axisbelow(True)
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_187.pdf", bbox_inches="tight")
