
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
years = [2022, 2023]
city_a_temps = [15.2, 16.1]  # Average temperatures for City A in the years 2022 and 2023
city_b_temps = [14.6, 15.3]  # Average temperatures for City B in the years 2022 and 2023
baseline_temp = 15.0  # Long-term average temperature

labels = ["City A", "City B"]
xlabel = "Year"
ylabel = "Average Temperature (°C)"
title = "Average Yearly Temperature by Year"
axlabels = "Baseline Temperature"

ylim = [13, 18]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(6.61, 5.23)
)  
bar_width = 0.35
index = np.arange(len(years))

bar1 = ax.bar(index, city_a_temps, bar_width, label=labels[0], color="#76b041")
bar2 = ax.bar(
    index + bar_width, city_b_temps, bar_width, label=labels[1], color="#f28e2b"
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.1f" % height,
        ha="center",
        va="bottom",
    )

# Baseline Temperature Line
ax.axhline(y=baseline_temp, color="red", linestyle="--", label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
# ax.set_title(title)
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(years)
ax.legend(loc="upper left")  
grid_color = "#b2b2b2"
ax.yaxis.grid(True)
ax.set_axisbelow(True)
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_188.pdf", bbox_inches="tight")

