
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the law domain
np.random.seed(2)
models = ["Firm A", "Firm B", "Firm C", "Firm D", "Firm E", "Firm F"]
won = [65, 55, 70, 60, 68, 72]
settled = [20, 25, 15, 25, 22, 18]
lost = [10, 15, 10, 10, 8, 7]
pending = [5, 5, 5, 5, 2, 3]

# Bar positions
x = np.arange(len(models))
labels = [
    "Won",
    "Settled",
    "Lost",
    "Pending",
]
ylabel = "Percentage"
title = "Performance of Law Firms in Handling Cases"
xlabel = "Law Firms"
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # Adjusted width for spacing

# Plotting
fig, ax = plt.subplots(
    figsize=(7, 5)
)  # Adjusted to match the image dimensions (504x360)

# Choosing a new color scheme tailored for law domain
ax.bar(x - 1.5 * width, won, width, label=labels[0], color="#66c2a5")  # Green
ax.bar(
    x - 0.5 * width,
    settled,
    width,
    label=labels[1],
    color="#fc8d62",
)  # Orange, with cross hatch
ax.bar(x + 0.5 * width, lost, width, label=labels[2], color="#8da0cb")  # Blue
ax.bar(
    x + 1.5 * width,
    pending,
    width,
    label=labels[3],
    color="#e78ac3",
)  # Pink, with slant hatch

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(models)
ax.set_ylim(ylim)  # Adjusted y-axis limit

# Move legend inside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_194.pdf", bbox_inches="tight")
