
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Recycling", "Afforestation", "Clean Energy", "Water Conservation", "Air Quality Improvement"][::-1]
cost = [70, 50, 90, 60, 80][::-1]
effectiveness = [80, 60, 85, 70, 75][::-1]
public_support = [40, 70, 95, 80, 85][::-1]

labels = ["Cost", "Effectiveness", "Public Support"]
y_pos = range(len(categories))

xlabel = 'Metrics Distribution'
ylabel = 'Environmental Interventions'
title = 'Comparison of Environmental Interventions Across Different Metrics'
legendlabels = ["Cost", "Effectiveness", "Public Support"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
color_cost = "#6a9fb5"
color_effectiveness = "#b5e1ad"
color_support = "#e18942"
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))

ax.barh(y_pos, cost, bar_width, color=color_cost, label=labels[0])
ax.barh(y_pos, effectiveness, bar_width, left=cost, color=color_effectiveness, label=labels[1])
ax.barh(
    y_pos,
    public_support,
    bar_width,
    left=[i + j for i, j in zip(cost, effectiveness)],
    color=color_support,
    label=labels[2],
)

# Adding the numerical values within each segment
for i in range(len(categories)):
    ax.text(
        cost[i] / 2,
        i,
        str(cost[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        cost[i] + effectiveness[i] / 2,
        i,
        str(effectiveness[i]),
        ha="center",
        va="center",
        color="black",
    )
    ax.text(
        cost[i] + effectiveness[i] + public_support[i] / 2,
        i,
        str(public_support[i]),
        ha="center",
        va="center",
        color="white",
    )

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks([])
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)
ax.legend(loc="upper right", labels=legendlabels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_195.pdf", bbox_inches="tight")
