

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
authors = ["Author A", "Author B", "Author C", "Author D", "Author E"][::-1]
books_sold = [500, 700, 300, 450, 600][::-1]
articles_published = [120, 200, 150, 90, 170][::-1]
citations_received = [800, 900, 700, 600, 750][::-1]

labels = ["Books Sold", "Articles Published", "Citations Received"]
y_pos = range(len(authors))

# Text labels
xlabel = "Statistics"
ylabel = "Authors"
title = "Literature Author Statistics"
legend_labels = ["Books Sold", "Articles Published", "Citations Received"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted to match typical presentation format

# Bar colors
colors = ['#003f5c', '#7a5195', '#ef5675']

# Plotting the bars
ax.barh(y_pos, books_sold, bar_width, color=colors[0], label=legend_labels[0])
ax.barh(y_pos, articles_published, bar_width, left=books_sold, color=colors[1], label=legend_labels[1])
ax.barh(
    y_pos,
    citations_received,
    bar_width,
    left=[i + j for i, j in zip(books_sold, articles_published)],
    color=colors[2],
    label=legend_labels[2],
)

# Adding the numerical values within each segment
for i in range(len(authors)):
    ax.text(
        books_sold[i] / 2,
        i,
        str(books_sold[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        books_sold[i] + articles_published[i] / 2,
        i,
        str(articles_published[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        books_sold[i] + articles_published[i] + citations_received[i] / 2,
        i,
        str(citations_received[i]),
        ha="center",
        va="center",
        color="white",
    )

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks([])
ax.set_yticks(y_pos)
ax.set_yticklabels(authors)
ax.set_title(title)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_196.pdf", bbox_inches="tight")

