
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
publications = np.array(
    [
        [60, 30, 55],
        [95, 110, 105],
        [80, 85, 90],
        [70, 75, 72],
        [60, 65, 63],
    ]
)
citations = np.array(
    [
        [220, 210, 205],
        [180, 170, 165],
        [160, 150, 140],
        [140, 130, 125],
        [120, 115, 110],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Aristotle",
    "Kant",
    "Heidegger",
    "Derrida",
    "Foucault",
]

ylabel = "Counts"
xlabel = "Year"
legendlabels = ["Publications", "Citations"]
ylim = [-250, 150]
xticks = [0, 1, 2]
xticklabels = ["2020", "2021", "2022"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(1, 5, figsize=(17, 4))

bar_color_pub = "#4c72b0"
bar_color_cit = "#c44e52"

for i in range(5):
    ax = axs[i]
    ax.bar(x, publications[i], width=0.35, label=legendlabels[0], color=bar_color_pub)
    ax.bar(x, -citations[i], width=0.35, label=legendlabels[1], color=bar_color_cit)
    ax.set_title(titles[i])
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_ylabel(ylabel)
    ax.set_xlabel(xlabel)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], publications[i][j] - 15, f'{publications[i][j]:.0f}', ha="center", color='blue'
        )
        ax.text(
            x[j],
            -citations[i][j] + 15,
            f'{citations[i][j]:.0f}',
            ha="center",
            color='red'
        )

# Add legend to the first subplot
axs[0].legend(loc="upper left", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.suptitle('Philosophical Trends: Publications vs. Citations', y=1.02, fontsize=16)
plt.savefig("bar_203.pdf", bbox_inches="tight")
