

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
technologies = ["AI", "IoT", "Blockchain", "5G", "AR/VR", "Cloud Computing", "Quantum Computing"]
growth_percentages = [40, 35, 25, 45, 30, 50, 20]
title = "Growth in Usage of Various Technologies Over the Past Decade"
xlabel = "Technology"
ylabel = "Usage Growth (%)"
ylim = [0, 55]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color palette with earthy tones
colors = ["#8FBC8F", "#6B8E23", "#556B2F", "#228B22", "#2E8B57", "#3CB371", "#32CD32"]

# Create figure and bar chart
plt.figure(figsize=(10, 6))
bars = plt.bar(technologies, growth_percentages, color=colors)

# Add percentage labels on top of each bar
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2, yval, f"{yval}%", ha="center", va="bottom",
        fontweight='bold', color='brown'
    )

# Set chart title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)

# Set y-axis range and gridlines
plt.ylim(ylim)
plt.grid(axis="y", linestyle="--", linewidth=0.7, alpha=0.7)

# Remove top and right spines for a cleaner look
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_217.pdf", bbox_inches="tight")

