
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
countries = ["USA", "China", "Japan", "Germany", "India", "UK", "France"]
gdp_values = [21.43, 14.34, 5.08, 3.86, 2.87, 2.83, 2.71]
title = "GDP of Different Countries"
xlabel = "Country"
ylabel = "GDP (Trillions USD)"
ylim = [0, 25]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart
plt.figure(figsize=(12, 7))
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700", "#FF69B4", "#8A2BE2"]
bars = plt.bar(countries, gdp_values, color=colors)

# Add percentage labels on top of each bar
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2, yval, f"{yval}%", ha="center", va="bottom"
    )

# Set chart title and labels
plt.title(title, fontsize=16, fontweight="bold")
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Set y-axis range and gridlines
plt.ylim(ylim)
plt.grid(axis="y", linestyle="--", alpha=0.7)

# Hide the top and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Adding a legend
plt.legend(["GDP"], loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_218.pdf", bbox_inches="tight")
