

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Data for the bar charts
categories = ["Healthcare Reform", "Education Funding", "Climate Action", "AVG"]
support = [45, 50, 55, 50, 60, 65, 70, 60, 55, 50, 45, 55, 50, 55, 60, 55]
neutral = [35, 30, 25, 30, 20, 15, 10, 20, 25, 30, 35, 25, 30, 25, 20, 25]
oppose = [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20]

labels = ["Support", "Neutral", "Oppose"]
titles = [
    "Public Opinion on Healthcare Reform (Region 1)",
    "Public Opinion on Education Funding (Region 2)",
    "Public Opinion on Climate Action (Region 3)",
    "Overall Public Opinion on Policies",
]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
colors = ["#1f78b4", "#a6cee3", "#b2df8a"]

fig, axes = plt.subplots(2, 2, figsize=(13, 6))


# Function to create a bar chart
def create_bar_chart(ax, support, neutral, oppose, title):
    bar_width = 0.5
    indices = np.arange(len(categories))

    ax.barh(indices, support, bar_width, color=colors[0], label=labels[0])
    ax.barh(indices, neutral, bar_width, left=support, color=colors[1], label=labels[1])
    ax.barh(
        indices,
        oppose,
        bar_width,
        left=np.add(support, neutral),
        color=colors[2],
        label=labels[2],
    )

    ax.set_yticks(indices)
    ax.set_yticklabels(categories)
    ax.invert_yaxis()
    ax.set_title(title)
    ax.set_xlim(0, 100)

    # Add text labels inside bars
    for i, (s, n, o) in enumerate(zip(support, neutral, oppose)):
        ax.text(s / 2, i, f"{s}%", ha="center", va="center", color="white")
        ax.text(s + n / 2, i, f"{n}%", ha="center", va="center", color="black")
        ax.text(s + n + o / 2, i, f"{o}%", ha="center", va="center", color="black")
        
    # Hide spines and add grid lines
    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.grid(axis='x', linestyle='--', alpha=0.7)
    ax.set_yticklabels(categories, rotation=45)


# Create each bar chart
create_bar_chart(axes[0, 0], support[:4], neutral[:4], oppose[:4], titles[0])
create_bar_chart(axes[1, 0], support[4:8], neutral[4:8], oppose[4:8], titles[1])
create_bar_chart(axes[0, 1], support[8:12], neutral[8:12], oppose[8:12], titles[2])
create_bar_chart(axes[1, 1], support[12:], neutral[12:], oppose[12:], titles[3])

# Add a legend
handles, labels = axes[0, 0].get_legend_handles_labels()
fig.legend(handles, labels, loc="lower center", ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.05, 1, 1])
plt.savefig("bar_219.pdf", bbox_inches="tight")

