
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
treatments = ["Treatment A", "Treatment B", "Treatment C", "Treatment D"]
recovery_time = [8, 6, 5, 9]
side_effects_severity = [6.5, 7.0, 5.5, 6.8]

labels = ["Recovery Time (days)", "Side Effects Severity (scale 1-10)"]

# X-axis positions
x = np.arange(len(treatments))
indexs = [2, 4]

# Plot labels
title_clinical1 = "(a) Clinical Trial 1"
title_clinical2 = "(b) Clinical Trial 2"
ylabel_recovery = "Time (days)"
ylabel_side_effects = "Severity (scale 1-10)"
yticks_recovery = np.arange(0, 10, 5)
yticks_side_effects = np.arange(0, 9, 1)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#17becf"]
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(5, 6))

barwidth = 0.3
# Clinical Trial 1 subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        recovery_time[i],
        width=0.3,
        label="Recovery Time",
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        side_effects_severity[i],
        width=0.3,
        label="Side Effects Severity",
        color=colors[i],
    )
ax1.set_title(title_clinical1)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_recovery)
ax1.set_yticks(yticks_recovery)
ax1.tick_params(axis="both", which="both", length=0)

# Clinical Trial 2 subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        recovery_time[i] - 2,  # Assume Clinical Trial 2 has slightly shorter recovery time on average
        width=0.3,
        label="Recovery Time",
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        side_effects_severity[i] + 0.5,  # Assume Clinical Trial 2 has slightly worse side effects on average
        width=0.3,
        label="Side Effects Severity",
        color=colors[i],
    )
ax2.set_title(title_clinical2)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_side_effects)
ax2.set_yticks(yticks_side_effects)

ax2.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_222.pdf", bbox_inches="tight")
