
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
experimental_techniques = ["Technique A", "Technique B", "Technique C", "Technique D"]
success_rates = [0.85, 0.80, 0.90, 0.75]
efficiency_scores = [0.70, 0.65, 0.85, 0.60]

labels = ["Success Rate", "Efficiency Score"]

# X-axis positions
x = np.arange(len(experimental_techniques))
indexs = [2, 4]

# Plot labels
success_title = "(a) Success Rates"
efficiency_title = "(b) Efficiency Scores"
ylabel_success = "Success Rate"
ylabel_efficiency = "Efficiency Score"
yticks_success = [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
yticks_efficiency = [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(5, 6))
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
barwidth = 0.3

# Success Rates subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        success_rates[i],
        width=0.3,
        label="Success Rate" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        efficiency_scores[i],
        width=0.3,
        label="Efficiency Score" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
ax1.set_title(success_title)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_success)
ax1.set_yticks(yticks_success)
ax1.tick_params(axis="both", which="both", length=0)
ax1.legend()

# Efficiency Scores subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        success_rates[i],
        width=0.3,
        label="Success Rate" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        efficiency_scores[i],
        width=0.3,
        label="Efficiency Score" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
ax2.set_title(efficiency_title)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_efficiency)
ax2.set_yticks(yticks_efficiency)
ax2.tick_params(axis="both", which="both", length=0)
ax2.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_224.pdf", bbox_inches="tight")
