

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data
months = ["January", "February", "March", "April"]
new_york_temp = [0.5, 12.3, 6.2, 11.0]
los_angeles_temp = [13.9, 14.4, 15.3, 17.0]
chicago_temp = [1.1, 0.1, 5.3, 11.1]
houston_temp = [11.1, 13.2, 17.6, 11.9]

labels = ["New York", "Los Angeles", "Chicago", "Houston"]
xlabel = "Months"
ylabel = "Average Temperature (°C)"
title = "Average Monthly Temperature in Different Cities"
yaxhline = 15.0
ylim = [-5, 30]
yticks = np.arange(-5, 35, 5)

# Positions of bars on x-axis
ind = np.arange(len(months))

texts = ["12.9", "15.0", "14.5", "14.9"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Figure size
plt.figure(figsize=(10, 7))

# Plotting
plt.bar(ind, new_york_temp, width=bar_width, label=labels[0], color="#1f77b4")
plt.bar(
    ind,
    los_angeles_temp,
    width=bar_width,
    label=labels[1],
    color="#aec7e8",
    hatch="//",
    bottom=new_york_temp,
)
plt.bar(ind + bar_width, chicago_temp, width=bar_width, label=labels[2], color="#ff7f0e")
plt.bar(
    ind + bar_width,
    houston_temp,
    width=bar_width,
    label=labels[3],
    color="#ffbb78",
    hatch="/",
    bottom=chicago_temp,
)

# Highlighting the most significant deviation
distance = 0.05
plt.annotate(
    "",
    xy=(ind[0] + bar_width, 15),
    xytext=(ind[0] + bar_width, 0.5),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[0] + bar_width + distance, 8.25, texts[0])
plt.annotate(
    "",
    xy=(ind[1], 15),
    xytext=(ind[1], 14.4),
    arrowprops=dict(facecolor="black", shrink=0.02),
    va="center",
)
plt.text(ind[1] - distance * 6, 14.7, texts[1])
plt.annotate(
    "",
    xy=(ind[2] + bar_width, 15),
    xytext=(ind[2] + bar_width, 5.3),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[2] + bar_width + distance, 10.15, texts[2])
plt.annotate(
    "",
    xy=(ind[3] + bar_width * 2, 15),
    xytext=(ind[3] + bar_width * 2, 21.9),
    arrowprops=dict(facecolor="red", shrink=0.02),
    ha="center",
)
plt.text(ind[3] + bar_width * 2 + distance, 18.45, texts[3])
plt.axhline(y=yaxhline, color="blue", linestyle="--", linewidth=2)

# X-axis labels
plt.xticks(ind + bar_width / 2, months)

# Y-axis labels
plt.ylim(ylim)
plt.yticks(yticks)

# Legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2)

# Grid lines
plt.grid(axis="y")

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_227.pdf", bbox_inches="tight")

