
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
art_movements = [
    "Renaissance",
    "Baroque",
    "Rococo",
    "Neoclassicism",
    "Romanticism",
    "Realism",
    "Impressionism",
    "Post-Impressionism",
    "Cubism",
    "Surrealism",
]
number_of_artworks = [220, 340, 280, 310, 295, 365, 480, 500, 540, 420]

# Axes Limits and Labels
xlabel_value = "Number of Notable Artworks"
title = "Number of Notable Artworks by Art Movement"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
fig, ax = plt.subplots(figsize=(12, 8))  # Adjust figure size to match original image's dimensions
colors = plt.cm.viridis(np.linspace(0, 1, len(art_movements)))  # Use a gradient color scheme
bars = ax.barh(art_movements, number_of_artworks, color=colors)  # Create bars with colors

# Axis labels
ax.set_xlabel(xlabel_value)
ax.set_title(title, fontsize=16)

# Customize ticks and labels
ax.xaxis.set_tick_params(labelsize=12)
ax.yaxis.set_tick_params(labelsize=12)

# Add data labels
for bar in bars:
    ax.text(
        bar.get_width() + 10, bar.get_y() + bar.get_height() / 2, 
        f'{int(bar.get_width())}', 
        va='center', ha='left', fontsize=10
    )

# Additional style adjustments
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.spines['left'].set_linewidth(0.7)
ax.spines['bottom'].set_linewidth(0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_232.pdf", bbox_inches="tight")
