
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sectors = [
    "Agriculture",
    "Manufacturing",
    "IT Services",
    "Financial Services",
    "Retail",
    "Energy",
    "Healthcare",
    "Education",
    "Transportation",
    "Real Estate",
]
gdp_contributions = [350, 800, 900, 350, 450, 300, 220, 150, 180, 500]

# Axes Limits and Labels
xlabel_value = "GDP Contribution (in billions)"
ylabel_value = "Economic Sectors"
title = "GDP Contribution by Economic Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match new data's dimensions
plt.barh(sectors, gdp_contributions, color=plt.cm.Greens(np.linspace(0.5, 1, len(sectors))))  # Gradient green colors
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=18)

# Add data labels
for index, value in enumerate(gdp_contributions):
    plt.text(
        value + 10, index, str(value), va="center", fontsize=12
    )  # Adjust text position and font size

plt.yticks(rotation=0, fontsize=12)
plt.xticks(fontsize=12)

# Add gridlines
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_233.pdf", bbox_inches="tight")
