
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Societal data for plotting
sectors = [
    "Agriculture", "Healthcare", "Education", "Manufacturing", 
    "Technology", "Retail", "Finance", "Construction", 
    "Transport", "Entertainment"
]
human_employment_estimate = [25, 40, 35, 30, 50, 45, 38, 28, 33, 42]
model_employment_prediction = [28, 38, 37, 33, 48, 43, 36, 31, 30, 40]

x = np.arange(len(sectors))  # the label locations
labels = ["Human Employment Estimate", "Model Employment Prediction"]
ylabel = "Employment Rate (%)"
xlabel = "Sectors"
title = "Employment Estimates vs Model Predictions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))

# Colors and Styles
human_color = "#2E8B57"
model_color = "#4682B4"
hatch_human = "///"
hatch_model = ".."
edge_color = "black"

# Create the bars
for i in range(len(sectors)):
    ax.bar(
        x[i],
        human_employment_estimate[i],
        color=human_color,
        label=labels[0] if i == 0 else "",
        hatch=hatch_human,
        edgecolor=edge_color
    )
    ax.bar(
        x[i],
        model_employment_prediction[i],
        bottom=human_employment_estimate[i],
        color=model_color,
        label=labels[1] if i == 0 else "",
        alpha=0.7,
        hatch=hatch_model,
        edgecolor=edge_color
    )

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(sectors, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_237.pdf", bbox_inches="tight")
