

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.cm as cm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Louvre", "British Museum", "Metropolitan Museum of Art", "Vatican Museums", "Tate Modern"]
values = [9.6, 6.1, 5.9, 5.6, 5.4]  # Visitor numbers in millions
title = "Top 5 Art Museums by Annual Visitors (Millions)"
xlabel = "Number of Visitors (Millions)"
xticks = np.arange(0, 11, 2)
xlabels = [str(x) for x in xticks]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create color map
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]
# Create horizontal bar chart
plt.figure(figsize=(8, 5))  # Adjusting figure size for better readability
plt.barh(categories, values, color=colors)

# Adding title and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xlabels, fontsize=10)
for spine in plt.gca().spines.values():
    spine.set_visible(False)
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_240.pdf", bbox_inches="tight")

