

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.cm as cm


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["New York", "Tokyo", "Sydney", "London", "Cairo"]
values = [62, 73, 75, 58, 82]  # Average temperatures in Fahrenheit
title = "Average Annual Temperatures in Major Cities"
xlabel = "Average Temperature (°F)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create color map
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Create horizontal bar chart
plt.figure(figsize=(10, 6))  # Adjusting figure size
plt.barh(categories, values, color=colors)

# Adding title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel("Cities")

# Customize ticks and labels if necessary
xticks = np.arange(50, 101, 10)
xlabels = [str(i) for i in xticks]

# Apply the xticks and labels
plt.xticks(xticks, xlabels)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_242.pdf", bbox_inches="tight")

